<?php

class PxlCountdown_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_countdown';
    protected $title = 'BR Countdown';
    protected $icon = 'eicon-countdown';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"countdown_section","label":"Content","tab":"content","controls":[{"name":"title","label":"Title","type":"textarea","placeholder":"Enter your title","description":"Create highlight text width shortcode: [highlight text=\"Text Demo\"]","label_block":true,"condition":{"layout":["2"]}},{"name":"date","label":"Date","type":"text","default":"2040\/10\/10","placeholder":"yy\/mm\/dd","label_block":true,"description":"Set date count down (Date format: yy\/mm\/dd)"},{"name":"day","label":"Days Text","type":"text","placeholder":"Days","label_block":true},{"name":"hour","label":"Hours Text","type":"text","placeholder":"Hours","label_block":true},{"name":"minute","label":"Minutes Text","type":"text","placeholder":"Minutes","label_block":true},{"name":"second","label":"Seconds Text","type":"text","placeholder":"Seconds","label_block":true},{"name":"align","label":"Alignment","type":"choose","control_type":"responsive","options":{"start":{"title":"Start","icon":"eicon-text-align-left"},"center":{"title":"Center","icon":"eicon-text-align-center"},"end":{"title":"End","icon":"eicon-text-align-right"}},"selectors":{"{{WRAPPER}} .pxl-countdown":"justify-content: {{VALUE}};"}}]},{"name":"section_style_countdown","label":"Countdown","tab":"style","controls":[{"name":"show_svg","label":"Pipe","type":"select","options":{"svg-on":"Show","svg-off":"Hidden"},"default":"svg-off","condition":{"layout":["1"]}},{"name":"countdown_color","label":"Number Color","type":"color","selectors":{"{{WRAPPER}} .countdown-item .countdown-amount":"color: {{VALUE}};"}},{"name":"darkmode_countdown_color","label":"Number Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .countdown-item .countdown-amount":"color: {{VALUE}};"}},{"name":"number_typography","label":"Number Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .countdown-item .countdown-amount"},{"name":"number_margin","label":"Number Margin","type":"dimensions","control_type":"responsive","size_units":["px","%","vw","vh"],"selectors":{"{{WRAPPER}} .countdown-item .countdown-amount":"margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"separator":"after"},{"name":"period_color","label":"Period Color","type":"color","selectors":{"{{WRAPPER}} .countdown-item .countdown-period":"color: {{VALUE}};"}},{"name":"darkmode_period_color","label":"Period Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .countdown-item .countdown-period":"color: {{VALUE}};"}},{"name":"period_typography","label":"Period Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .countdown-item .countdown-period","separator":"after"},{"name":"dot_color","label":"Dot Color","type":"color","selectors":{"{{WRAPPER}} .countdown-item:after":"color: {{VALUE}};"},"condition":{"show_svg":"svg-off"}},{"name":"darkmode_dot_color","label":"Dot Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .countdown-item:after":"color: {{VALUE}};"},"condition":{"show_svg":"svg-off"}},{"name":"dot_size","label":"Dot Size (px)","type":"slider","range":{"px":{"min":0,"max":300}},"condition":{"show_svg":"svg-off"},"selectors":{"{{WRAPPER}} .countdown-item:after":"font-size: {{SIZE}}{{UNIT}};"}},{"name":"dot_margin","label":"Dot Margin","type":"dimensions","control_type":"responsive","size_units":["px","%","vw","vh"],"selectors":{"{{WRAPPER}} .countdown-item:after":"margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"condition":{"show_svg":"svg-off"}},{"name":"svg_color","label":"SVG Color","type":"color","selectors":{"{{WRAPPER}} .countdown-item-inner svg":"fill: {{VALUE}};"},"condition":{"show_svg":"svg-on"}},{"name":"darkmode_svg_color","label":"SVG Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .countdown-item-inner svg":"fill: {{VALUE}};"},"condition":{"show_svg":"svg-on"}},{"name":"svg_size","label":"SVG Size","type":"slider","control_type":"responsive","size_units":["px","%","vw","vh"],"range":{"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .countdown-item-inner":"width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}; min-width: {{SIZE}}{{UNIT}}; border-radius: {{SIZE}}{{UNIT}};"},"condition":{"show_svg":"svg-on"}}]},{"name":"section_style_box","label":"Box","tab":"style","controls":[{"name":"countdown_bg_color","label":"Countdown Background Color","type":"color","selectors":{"{{WRAPPER}} .pxl-countdown":"background-color: {{VALUE}};"}},{"name":"darkmode_countdown_bg_color","label":"Countdown Background Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-countdown":"background-color: {{VALUE}};"}},{"name":"countdown_padding","label":"Countdown Padding","type":"dimensions","control_type":"responsive","size_units":["px","%","vw","vh"],"default":{"unit":"px"},"range":{"px":{"min":0,"max":3000},"%":{"min":0,"max":100}},"selectors":{"{{WRAPPER}} .pxl-countdown":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"c_width","label":"Max Width","type":"slider","control_type":"responsive","size_units":["px","%","vw","vh"],"range":{"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-countdown-wrap .pxl-countdown":"max-width: {{SIZE}}{{UNIT}};"},"separator":"after"},{"name":"border_type","label":"Border Type","type":"select","options":{"":"None","solid":"Solid","double":"Double","dotted":"Dotted","dashed":"Dashed","groove":"Groove"},"selectors":{"{{WRAPPER}} .pxl-countdown-wrap":"border-style: {{VALUE}};"}},{"name":"border_width","label":"Border Width","type":"dimensions","selectors":{"{{WRAPPER}} .pxl-countdown-wrap":"border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"condition":{"border_type!":""},"responsive":true},{"name":"border_color","label":"Border Color","type":"color","selectors":{"{{WRAPPER}} .pxl-countdown-wrap":"border-color: {{VALUE}};"},"condition":{"border_type!":""}},{"name":"darkmode_border_color","label":"Border Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-countdown-wrap":"border-color: {{VALUE}};"},"condition":{"border_type!":""}},{"name":"box_padding","label":"Box Padding","type":"dimensions","control_type":"responsive","size_units":["px","%","vw","vh"],"default":{"unit":"px"},"range":{"px":{"min":0,"max":3000},"%":{"min":0,"max":100}},"selectors":{"{{WRAPPER}} .pxl-countdown-wrap":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"section_animation","label":"Animation","tab":"style","condition":[],"controls":[{"name":"pxl_animate","label":"Case Animate","type":"select","options":{"":"None","wow bounce":"bounce","wow flash":"flash","wow pulse":"pulse","wow rubberBand":"rubberBand","wow shake":"shake","wow swing":"swing","wow tada":"tada","wow wobble":"wobble","wow bounceIn":"bounceIn","wow bounceInDown":"bounceInDown","wow bounceInLeft":"bounceInLeft","wow bounceInRight":"bounceInRight","wow bounceInUp":"bounceInUp","wow bounceOut":"bounceOut","wow bounceOutDown":"bounceOutDown","wow bounceOutLeft":"bounceOutLeft","wow bounceOutRight":"bounceOutRight","wow bounceOutUp":"bounceOutUp","wow fadeIn":"fadeIn","wow fadeInDown":"fadeInDown","wow fadeInDownBig":"fadeInDownBig","wow fadeInLeft":"fadeInLeft","wow fadeInLeftBig":"fadeInLeftBig","wow fadeInRight":"fadeInRight","wow fadeInRightBig":"fadeInRightBig","wow fadeInUp":"fadeInUp","wow fadeInUpBig":"fadeInUpBig","wow fadeOut":"fadeOut","wow fadeOutDown":"fadeOutDown","wow fadeOutDownBig":"fadeOutDownBig","wow fadeOutLeft":"fadeOutLeft","wow fadeOutLeftBig":"fadeOutLeftBig","wow fadeOutRight":"fadeOutRight","wow fadeOutRightBig":"fadeOutRightBig","wow fadeOutUp":"fadeOutUp","wow fadeOutUpBig":"fadeOutUpBig","wow flip":"flip","wow flipCase":"flipCase","wow flipInX":"flipInX","wow flipInY":"flipInY","wow flipOutX":"flipOutX","wow flipOutY":"flipOutY","wow lightSpeedIn":"lightSpeedIn","wow lightSpeedOut":"lightSpeedOut","wow rotateIn":"rotateIn","wow rotateInDownLeft":"rotateInDownLeft","wow rotateInDownRight":"rotateInDownRight","wow rotateInUpLeft":"rotateInUpLeft","wow rotateInUpRight":"rotateInUpRight","wow rotateOut":"rotateOut","wow rotateOutDownLeft":"rotateOutDownLeft","wow rotateOutDownRight":"rotateOutDownRight","wow rotateOutUpLeft":"rotateOutUpLeft","wow rotateOutUpRight":"rotateOutUpRight","wow hinge":"hinge","wow rollIn":"rollIn","wow rollOut":"rollOut","wow zoomInSmall":"zoomInSmall","wow zoomIn":"zoomInBig","wow zoomOut":"zoomOut","wow skewIn":"skewInLeft","wow skewInRight":"skewInRight","wow skewInBottom":"skewInBottom","wow RotatingY":"RotatingY","wow PXLfadeInUp":"PXLfadeInUp","fadeInPopup":"fadeInPopup"},"default":""},{"name":"pxl_animate_delay","label":"Animate Delay","type":"text","default":"0","description":"Enter number. Default 0ms"}]}]}';
    protected $styles = array(  );
    protected $scripts = array( 'clearpress-countdown' );
}